#ifdef PRECOMPILEDHEADERS
	#include "Tactical All.h"
#else
	#include "builddefines.h"
	#include <stdio.h>
	#include <string.h>
	#include "wcheck.h"
	#include "stdlib.h"
	#include "debug.h"
	#include "Animation Data.h"
	#include "Animation Control.h"

	#include "jascreens.h"
	#include "tiledef.h"
	#include "Sys Globals.h"
	#include "Debug Control.h"
	#include "utilities.h"
	#include "worlddef.h"
	#include "worldman.h"
	#include "Fileman.h"
#endif

//forward declarations of common classes to eliminate includes
class OBJECTTYPE;
class SOLDIERTYPE;


#define EMPTY_SLOT		-1
#define TO_INIT				0

#define	ANIMPROFILEFILENAME			"BINARYDATA\\JA2PROF.DAT"



ANIM_PROF		*gpAnimProfiles = NULL;
UINT8				gubNumAnimProfiles = 0;

INT8				gbAnimUsageHistory[ NUMANIMATIONSURFACETYPES ][ MAX_NUM_SOLDIERS ];



AnimationSurfaceType	gAnimSurfaceDatabase[ NUMANIMATIONSURFACETYPES ] =
{
	RGMBASICWALKING,		"ANIMS\\S_MERC\\S_R_WALK.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMSTANDING,				"ANIMS\\S_MERC\\S_R_STD.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMCROUCHING,				"ANIMS\\S_MERC\\S_R_C.STI",			C_STRUCT,		0,		8, TO_INIT, NULL, NULL, 0, -1,
	RGMSNEAKING,				"ANIMS\\S_MERC\\S_R_SWAT.STI",	C_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMRUNNING,					"ANIMS\\S_MERC\\S_R_RUN.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMPRONE,						"ANIMS\\S_MERC\\S_R_PRN.STI",		P_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, 0,
	RGMSTANDAIM,				"ANIMS\\S_MERC\\S_SR_AIM.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMHITHARD,					"ANIMS\\S_MERC\\S_DIEHD.STI",		FB_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMHITSTAND,				"ANIMS\\S_MERC\\S_DIEFWD.STI",	F_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMHITHARDBLOOD,		"ANIMS\\S_MERC\\S_DIEHDB.STI",	FB_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMCROUCHAIM,				"ANIMS\\S_MERC\\S_CR_AIM.STI",	C_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMHITFALLBACK,			"ANIMS\\S_MERC\\S_DIEBAC.STI",	FB_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMROLLOVER,				"ANIMS\\S_MERC\\S_ROLL.STI",		P_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMCLIMBROOF,				"ANIMS\\S_MERC\\S_CLIMB.STI",		S_STRUCT,		0,			4, TO_INIT, NULL, NULL, 0, -1,
	RGMFALL,						"ANIMS\\S_MERC\\S_FALL.STI",		S_STRUCT,		0,			4, TO_INIT, NULL, NULL, 0, -1,
	RGMFALLF,						"ANIMS\\S_MERC\\S_FALLF.STI",		S_STRUCT,		0,			4, TO_INIT, NULL, NULL, 0, -1,
	RGMHITCROUCH,				"ANIMS\\S_MERC\\S_C_DIE.STI",		C_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMHITPRONE,				"ANIMS\\S_MERC\\S_P_DIE.STI", 	P_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMHOPFENCE,				"ANIMS\\S_MERC\\S_HOP.STI",			NO_STRUCT,	0,			4, TO_INIT, NULL, NULL, 0, -1,
	RGMPUNCH,						"ANIMS\\S_MERC\\S_PUNCH.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMNOTHING_STD,			"ANIMS\\S_MERC\\S_N_STD.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMNOTHING_WALK,		"ANIMS\\S_MERC\\S_N_WALK.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMNOTHING_RUN,			"ANIMS\\S_MERC\\S_N_RUN.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMNOTHING_SWAT,		"ANIMS\\S_MERC\\S_N_SWAT.STI",	C_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMNOTHING_CROUCH,	"ANIMS\\S_MERC\\S_N_CRCH.STI",	C_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMHANDGUN_S_SHOT,	"ANIMS\\S_MERC\\S_N_SHOT.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMHANDGUN_C_SHOT,	"ANIMS\\S_MERC\\S_N_C_AI.STI",	C_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMHANDGUN_PRONE,		"ANIMS\\S_MERC\\S_N_PRNE.STI",	P_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMDIE_JFK,					"ANIMS\\S_MERC\\S_DIEJFK.STI",	F_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMOPEN,						"ANIMS\\S_MERC\\S_OPEN.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMPICKUP,					"ANIMS\\S_MERC\\S_PICKUP.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMSTAB,						"ANIMS\\S_MERC\\S_STAB.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMSLICE,						"ANIMS\\S_MERC\\S_SLICE.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMCSTAB,						"ANIMS\\S_MERC\\S_C_STB.STI",		C_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMMEDIC,						"ANIMS\\S_MERC\\S_MEDIC.STI",		C_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMDODGE,						"ANIMS\\S_MERC\\S_DODGE.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMSTANDDWALAIM,		"ANIMS\\S_MERC\\S_DBLSHT.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMRAISE,						"ANIMS\\S_MERC\\S_RAISE.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMTHROW,						"ANIMS\\S_MERC\\S_LOB.STI",			S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMLOB,							"ANIMS\\S_MERC\\S_THROW.STI",			S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMKICKDOOR,				"ANIMS\\S_MERC\\S_DR_KCK.STI",	S_STRUCT,		0,			4, TO_INIT, NULL, NULL, 0, -1,
	RGMRHIT,						"ANIMS\\S_MERC\\S_R_HIT.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGM_SQUISH,					"ANIMS\\S_MERC\\A_SQUISH.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGM_LOOK,						"ANIMS\\S_MERC\\A_LOOK.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGM_PULL,						"ANIMS\\S_MERC\\A_PULL.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGM_SPIT,						"ANIMS\\S_MERC\\A_SPIT.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMWATER_R_WALK,		"ANIMS\\S_MERC\\SW_R_WALK.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMWATER_R_STD,			"ANIMS\\S_MERC\\SW_R_STD.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMWATER_N_WALK,		"ANIMS\\S_MERC\\SW_N_WALK.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMWATER_N_STD,			"ANIMS\\S_MERC\\SW_N_STD.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMWATER_DIE,				"ANIMS\\S_MERC\\SW_DIE.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMWATER_N_AIM,			"ANIMS\\S_MERC\\SW_N_SHOT.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMWATER_R_AIM,			"ANIMS\\S_MERC\\SW_SR_AIM.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMWATER_DBLSHT,		"ANIMS\\S_MERC\\SW_DBLSHT.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMWATER_TRANS,			"ANIMS\\S_MERC\\SW_FALL.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMDEEPWATER_TRED,	"ANIMS\\S_MERC\\S_TRED.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMDEEPWATER_SWIM,	"ANIMS\\S_MERC\\S_SWIM.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMDEEPWATER_DIE,		"ANIMS\\S_MERC\\S_D_DIE.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMMCLIMB,					"ANIMS\\S_MERC\\S_MCLIMB.STI",	S_STRUCT,		0,			3, TO_INIT, NULL, NULL, 0, -1,
	RGMHELIDROP,				"ANIMS\\S_MERC\\S_HELIDRP.STI",	S_STRUCT,		0,			1, TO_INIT, NULL, NULL, 0, -1,
	RGMLOWKICK,					"ANIMS\\S_MERC\\K_LW_KICK.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMPUNCH,						"ANIMS\\S_MERC\\K_PUNCH.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMSPINKICK,				"ANIMS\\S_MERC\\S_SPNKCK.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMSLEEP,						"ANIMS\\S_MERC\\S_SLEEP.STI",		P_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMSHOOT_LOW,				"ANIMS\\S_MERC\\S_SHTLO.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMCDBLSHOT,				"ANIMS\\S_MERC\\SC_DBLSH.STI",	C_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMHURTSTANDINGN,		"ANIMS\\S_MERC\\S_I_BR_N.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMHURTSTANDINGR,		"ANIMS\\S_MERC\\S_I_BR_R.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMHURTWALKINGN,		"ANIMS\\S_MERC\\S_I_WK_N.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMHURTWALKINGR,		"ANIMS\\S_MERC\\S_I_WK_R.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMHURTTRANS,				"ANIMS\\S_MERC\\S_I_TRAN.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMTHROWKNIFE,			"ANIMS\\S_MERC\\S_K_THRO.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMBREATHKNIFE,			"ANIMS\\S_MERC\\S_KNF_BR.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMPISTOLBREATH,		"ANIMS\\S_MERC\\S_P_BRTH.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMCOWER,						"ANIMS\\S_MERC\\S_COWER.STI",		C_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMROCKET,					"ANIMS\\S_MERC\\S_LAW.STI",			S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMMORTAR,					"ANIMS\\S_MERC\\S_MORTAR.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMSIDESTEP,				"ANIMS\\S_MERC\\S_R_SDSP.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMDBLBREATH,				"ANIMS\\S_MERC\\S_DBL_BR.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMPUNCHLOW,				"ANIMS\\S_MERC\\S_PCH_LO.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMPISTOLSHOOTLOW,	"ANIMS\\S_MERC\\S_P_SHLO.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMWATERTHROW,			"ANIMS\\S_MERC\\SW_LOB.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMRADIO,						"ANIMS\\S_MERC\\S_RADIO.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMCRRADIO,					"ANIMS\\S_MERC\\S_C_RADO.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMBURN,						"ANIMS\\S_MERC\\S_FIRE.STI",		S_STRUCT,		0,			1, TO_INIT, NULL, NULL, 0, -1,
	RGMDWPRONE,					"ANIMS\\S_MERC\\S_DB_PRN.STI",	P_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMDRUNK,						"ANIMS\\S_MERC\\S_R_DRNK.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMPISTOLDRUNK,			"ANIMS\\S_MERC\\S_N_DRNK.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMCROWBAR,					"ANIMS\\S_MERC\\S_CROBAR.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMJUMPOVER,				"ANIMS\\S_MERC\\S_N_RUN.STI",		NO_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,


	BGMWALKING,					"ANIMS\\M_MERC\\M_R_WALK.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMSTANDING,				"ANIMS\\M_MERC\\M_R_STD.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMCROUCHING,				"ANIMS\\M_MERC\\M_R_C.STI",			C_STRUCT,		0,		8, TO_INIT, NULL, NULL, 0, -1,
	BGMSNEAKING,				"ANIMS\\M_MERC\\M_R_SWAT.STI",	C_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMRUNNING,					"ANIMS\\M_MERC\\M_R_RUN2.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMPRONE,						"ANIMS\\M_MERC\\M_R_PRN.STI",		P_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, 0,
	BGMSTANDAIM,				"ANIMS\\M_MERC\\M_SR_AIM.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMHITHARD,					"ANIMS\\M_MERC\\M_DIEHD.STI",		FB_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMHITSTAND,				"ANIMS\\M_MERC\\M_DIEFWD.STI",	F_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMHITHARDBLOOD,		"ANIMS\\M_MERC\\M_DIEHDB.STI",	FB_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMCROUCHAIM,				"ANIMS\\M_MERC\\M_CR_AIM.STI",	C_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMHITFALLBACK,			"ANIMS\\M_MERC\\M_DIEBAC.STI",	FB_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMROLLOVER,				"ANIMS\\M_MERC\\M_ROLL.STI",		P_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMCLIMBROOF,				"ANIMS\\M_MERC\\M_CLIMB.STI",		S_STRUCT,		0,			4, TO_INIT, NULL, NULL, 0, -1,
	BGMFALL,						"ANIMS\\M_MERC\\M_FALL.STI",		S_STRUCT,		0,			4, TO_INIT, NULL, NULL, 0, -1,
	BGMFALLF,						"ANIMS\\M_MERC\\M_FALLF.STI",		S_STRUCT,		0,			4, TO_INIT, NULL, NULL, 0, -1,
	BGMHITCROUCH,				"ANIMS\\M_MERC\\M_C_DIE.STI",		C_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMHITPRONE,				"ANIMS\\M_MERC\\M_P_DIE.STI",		P_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMHOPFENCE,				"ANIMS\\M_MERC\\M_HOP.STI",			NO_STRUCT,	0,			4, TO_INIT, NULL, NULL, 0, -1,
	BGMPUNCH,						"ANIMS\\M_MERC\\M_PUNCH.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMNOTHING_STD,			"ANIMS\\M_MERC\\M_N_STD.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMNOTHING_WALK,		"ANIMS\\M_MERC\\M_N_WALK.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMNOTHING_RUN,			"ANIMS\\M_MERC\\M_N_RUN.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMNOTHING_SWAT,		"ANIMS\\M_MERC\\M_N_SWAT.STI",	C_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMNOTHING_CROUCH,	"ANIMS\\M_MERC\\M_N_CRCH.STI",	C_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMHANDGUN_S_SHOT,	"ANIMS\\M_MERC\\M_N_SHOT.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMHANDGUN_C_SHOT,	"ANIMS\\M_MERC\\M_N_C_AI.STI",	C_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMHANDGUN_PRONE,		"ANIMS\\M_MERC\\M_N_PRNE.STI",	P_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMDIE_JFK,					"ANIMS\\M_MERC\\M_DIEJFK.STI",	F_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMOPEN,						"ANIMS\\M_MERC\\M_OPEN.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMPICKUP,					"ANIMS\\M_MERC\\M_PICKUP.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMSTAB,						"ANIMS\\M_MERC\\M_STAB.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMSLICE,						"ANIMS\\M_MERC\\M_SLICE.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMCSTAB,						"ANIMS\\M_MERC\\M_C_STB.STI",		C_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMMEDIC,						"ANIMS\\M_MERC\\M_MEDIC.STI",		C_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMDODGE,						"ANIMS\\M_MERC\\M_DODGE.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMSTANDDWALAIM,		"ANIMS\\M_MERC\\M_DBLSHT.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMRAISE,						"ANIMS\\M_MERC\\M_RAISE.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMTHROW,						"ANIMS\\M_MERC\\M_THROW.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMLOB,							"ANIMS\\M_MERC\\M_LOB.STI",			S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMKICKDOOR,				"ANIMS\\M_MERC\\M_DR_KCK.STI",	S_STRUCT,		0,			4, TO_INIT, NULL, NULL, 0, -1,
	BGMRHIT,						"ANIMS\\M_MERC\\M_R_HIT.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMSTANDAIM2,				"ANIMS\\M_MERC\\M_SR_AM2.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMFLEX,						"ANIMS\\M_MERC\\M_FLEX.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMSTRECH,					"ANIMS\\M_MERC\\M_STRTCH.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMSHOEDUST,				"ANIMS\\M_MERC\\M_SHOEDUST.STI",S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMHEADTURN,				"ANIMS\\M_MERC\\M_HEDTURN.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMWATER_R_WALK,		"ANIMS\\M_MERC\\MW_R_WAL.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMWATER_R_STD,			"ANIMS\\M_MERC\\MW_R_STD.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMWATER_N_WALK,		"ANIMS\\M_MERC\\MW_N_WAL.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMWATER_N_STD,			"ANIMS\\M_MERC\\MW_N_STD.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMWATER_DIE,				"ANIMS\\M_MERC\\MW_DIE.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMWATER_N_AIM,			"ANIMS\\M_MERC\\MW_N_SHT.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMWATER_R_AIM,			"ANIMS\\M_MERC\\MW_SR_AM.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMWATER_DBLSHT,		"ANIMS\\M_MERC\\MW_DBL.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMWATER_TRANS,			"ANIMS\\M_MERC\\MW_FALL.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMDEEPWATER_TRED,	"ANIMS\\M_MERC\\MW_TRED.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMDEEPWATER_SWIM,	"ANIMS\\M_MERC\\MW_SWIM.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMDEEPWATER_DIE,		"ANIMS\\M_MERC\\MW_DIE2.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMHELIDROP,				"ANIMS\\M_MERC\\M_HELIDRP.STI",	S_STRUCT,		0,			1, TO_INIT, NULL, NULL, 0, -1,
	BGMSLEEP,						"ANIMS\\M_MERC\\M_SLEEP.STI",		P_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMSHOOT_LOW,				"ANIMS\\M_MERC\\M_SHTLOW.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMTHREATENSTAND,		"ANIMS\\M_MERC\\M_BRETH2.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMCDBLSHOT,				"ANIMS\\M_MERC\\MC_DBLSH.STI",	C_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMHURTSTANDINGN,		"ANIMS\\M_MERC\\M_I_BR_N.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMHURTSTANDINGR,		"ANIMS\\M_MERC\\M_I_BR_R.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMHURTWALKINGN,		"ANIMS\\M_MERC\\M_I_WK_N.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMHURTWALKINGR,		"ANIMS\\M_MERC\\M_I_WK_R.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMHURTTRANS,				"ANIMS\\M_MERC\\M_I_TRAN.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMTHROWKNIFE,			"ANIMS\\M_MERC\\M_K_THRO.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMBREATHKNIFE,			"ANIMS\\M_MERC\\M_KNF_BR.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMPISTOLBREATH,		"ANIMS\\M_MERC\\M_P_BRTH.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMCOWER,						"ANIMS\\M_MERC\\M_COWER.STI",		C_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMRAISE2,					"ANIMS\\M_MERC\\M_RAISE2.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMROCKET,					"ANIMS\\M_MERC\\M_LAW.STI",			S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMMORTAR,					"ANIMS\\M_MERC\\M_MORTAR.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMSIDESTEP,				"ANIMS\\M_MERC\\M_R_SDSP.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMDBLBREATH,				"ANIMS\\M_MERC\\M_DBL_BR.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMPUNCHLOW,				"ANIMS\\M_MERC\\M_PCH_LO.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMPISTOLSHOOTLOW,	"ANIMS\\M_MERC\\M_P_SHLO.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMWATERTHROW,			"ANIMS\\M_MERC\\MW_THROW.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMWALK2,						"ANIMS\\M_MERC\\M_WALK2.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMRUN2,						"ANIMS\\M_MERC\\M_R_RUN.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMIDLENECK,				"ANIMS\\M_MERC\\M_NECK.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMCROUCHTRANS,			"ANIMS\\M_MERC\\M_C_TRAN.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMRADIO,						"ANIMS\\M_MERC\\M_RADIO.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMCRRADIO,					"ANIMS\\M_MERC\\M_C_RADO.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMDWPRONE,					"ANIMS\\M_MERC\\M_DB_PRN.STI",	P_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMDRUNK,						"ANIMS\\M_MERC\\M_R_DRNK.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMPISTOLDRUNK,			"ANIMS\\M_MERC\\M_N_DRNK.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMCROWBAR,					"ANIMS\\M_MERC\\M_CROBAR.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMJUMPOVER,				"ANIMS\\M_MERC\\M_N_RUN.STI",		NO_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,


	RGFWALKING,					"ANIMS\\F_MERC\\F_R_WALK.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFSTANDING,				"ANIMS\\F_MERC\\F_BRETH2.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFCROUCHING,				"ANIMS\\F_MERC\\F_R_C.STI",			C_STRUCT,		0,		8, TO_INIT, NULL, NULL, 0, -1,
	RGFSNEAKING,				"ANIMS\\F_MERC\\F_R_SWAT.STI",	C_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFRUNNING,					"ANIMS\\F_MERC\\F_R_RUN.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFPRONE,						"ANIMS\\F_MERC\\F_R_PRN.STI",		P_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, 0,
	RGFSTANDAIM,				"ANIMS\\F_MERC\\F_SR_AIM.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFHITHARD,					"ANIMS\\F_MERC\\F_DIEHD.STI",		FB_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFHITSTAND,				"ANIMS\\F_MERC\\F_DIEFWD.STI",	F_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFHITHARDBLOOD,		"ANIMS\\F_MERC\\F_DIEHDB.STI",	FB_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFCROUCHAIM,				"ANIMS\\F_MERC\\F_CR_AIM.STI",	C_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFHITFALLBACK,			"ANIMS\\F_MERC\\F_DIEBAC.STI",	F_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFROLLOVER,				"ANIMS\\F_MERC\\F_ROLL.STI",		P_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFCLIMBROOF,				"ANIMS\\F_MERC\\F_CLIMB.STI",		S_STRUCT,		0,			4, TO_INIT, NULL, NULL, 0, -1,
	RGFFALL,						"ANIMS\\F_MERC\\F_FALL.STI",		S_STRUCT,		0,			4, TO_INIT, NULL, NULL, 0, -1,
	RGFFALLF,						"ANIMS\\F_MERC\\F_FALLF.STI",		S_STRUCT,		0,			4, TO_INIT, NULL, NULL, 0, -1,
	RGFHITCROUCH,				"ANIMS\\F_MERC\\F_C_DIE.STI",		C_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFHITPRONE,				"ANIMS\\F_MERC\\F_P_DIE.STI",		P_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFHOPFENCE,				"ANIMS\\F_MERC\\F_HOP.STI",			NO_STRUCT,	0,			4, TO_INIT, NULL, NULL, 0, -1,
	RGFPUNCH,						"ANIMS\\F_MERC\\F_PUNCH.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFNOTHING_STD,			"ANIMS\\F_MERC\\N_BRETH2.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFNOTHING_WALK,		"ANIMS\\F_MERC\\F_N_WALK.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFNOTHING_RUN,			"ANIMS\\F_MERC\\F_N_RUN.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFNOTHING_SWAT,		"ANIMS\\F_MERC\\F_N_SWAT.STI",	C_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFNOTHING_CROUCH,	"ANIMS\\F_MERC\\F_N_CRCH.STI",	C_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFHANDGUN_S_SHOT,	"ANIMS\\F_MERC\\F_N_SHOT.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFHANDGUN_C_SHOT,	"ANIMS\\F_MERC\\F_N_C_AI.STI",	C_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFHANDGUN_PRONE,		"ANIMS\\F_MERC\\F_N_PRNE.STI",	P_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFDIE_JFK,					"ANIMS\\F_MERC\\F_DIEJFK.STI",	F_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFOPEN,						"ANIMS\\F_MERC\\F_OPEN.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFPICKUP,					"ANIMS\\F_MERC\\F_PICKUP.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFSTAB,						"ANIMS\\F_MERC\\F_STAB.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFSLICE,						"ANIMS\\F_MERC\\F_SLICE.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFCSTAB,						"ANIMS\\F_MERC\\F_C_STB.STI",		C_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFMEDIC,						"ANIMS\\F_MERC\\F_MEDIC.STI",		C_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFDODGE,						"ANIMS\\F_MERC\\F_DODGE.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFSTANDDWALAIM,		"ANIMS\\F_MERC\\F_DBLSHT.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFRAISE,						"ANIMS\\F_MERC\\F_RAISE.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFTHROW,						"ANIMS\\F_MERC\\F_THROW.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFLOB,							"ANIMS\\F_MERC\\F_LOB.STI",			S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFKICKDOOR,				"ANIMS\\F_MERC\\F_DR_KCK.STI",	S_STRUCT,		0,			4, TO_INIT, NULL, NULL, 0, -1,
	RGFRHIT,						"ANIMS\\F_MERC\\F_R_HIT.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFCLEAN,						"ANIMS\\F_MERC\\A_CLEAN.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFKICKSN,					"ANIMS\\F_MERC\\A_KICKSN.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFALOOK,						"ANIMS\\F_MERC\\A_LOOK.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFWIPE,						"ANIMS\\F_MERC\\A_WIPE.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFWATER_R_WALK,		"ANIMS\\F_MERC\\FW_R_WLK.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFWATER_R_STD,			"ANIMS\\F_MERC\\FW_R_STD.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFWATER_N_WALK,		"ANIMS\\F_MERC\\FW_N_WLK.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFWATER_N_STD,			"ANIMS\\F_MERC\\FW_N_STD.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFWATER_DIE,				"ANIMS\\F_MERC\\FW_DIE.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFWATER_N_AIM,			"ANIMS\\F_MERC\\FW_N_SHT.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFWATER_R_AIM,			"ANIMS\\F_MERC\\FW_SR_AI.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFWATER_DBLSHT,		"ANIMS\\F_MERC\\FW_DBL.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFWATER_TRANS,			"ANIMS\\F_MERC\\FW_FALL.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFDEEPWATER_TRED,	"ANIMS\\F_MERC\\FW_TRED.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFDEEPWATER_SWIM,	"ANIMS\\F_MERC\\FW_SWIM.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFDEEPWATER_DIE,		"ANIMS\\F_MERC\\FW_DIE2.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFHELIDROP,				"ANIMS\\F_MERC\\F_HELIDRP.STI",	S_STRUCT,		0,			1, TO_INIT, NULL, NULL, 0, -1,
	RGFSLEEP,						"ANIMS\\F_MERC\\F_SLEEP.STI",		P_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFSHOOT_LOW,				"ANIMS\\F_MERC\\F_SHTLOW.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFCDBLSHOT,				"ANIMS\\F_MERC\\FC_DBLSH.STI",	C_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFHURTSTANDINGN,		"ANIMS\\F_MERC\\F_I_BR_N.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFHURTSTANDINGR,		"ANIMS\\F_MERC\\F_I_BR_R.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFHURTWALKINGN,		"ANIMS\\F_MERC\\F_I_WK_N.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFHURTWALKINGR,		"ANIMS\\F_MERC\\F_I_WK_R.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFHURTTRANS,				"ANIMS\\F_MERC\\F_I_TRAN.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFTHROWKNIFE,			"ANIMS\\F_MERC\\F_K_THRO.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFBREATHKNIFE,			"ANIMS\\F_MERC\\F_KNF_BR.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFPISTOLBREATH,		"ANIMS\\F_MERC\\F_P_BRTH.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFCOWER,						"ANIMS\\F_MERC\\F_COWER.STI",		C_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFROCKET,					"ANIMS\\F_MERC\\F_LAW.STI",			S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFMORTAR,					"ANIMS\\F_MERC\\F_MORTAR.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFSIDESTEP,				"ANIMS\\F_MERC\\F_R_SDSP.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFDBLBREATH,				"ANIMS\\F_MERC\\F_DBL_BR.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFPUNCHLOW,				"ANIMS\\F_MERC\\F_PCH_LO.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFPISTOLSHOOTLOW,	"ANIMS\\F_MERC\\F_P_SHLO.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFWATERTHROW,			"ANIMS\\F_MERC\\FW_THRW.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFRADIO,						"ANIMS\\F_MERC\\F_RADIO.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFCRRADIO,					"ANIMS\\F_MERC\\F_C_RADO.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFSLAP,						"ANIMS\\F_MERC\\F_SLAP.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFDWPRONE,					"ANIMS\\F_MERC\\F_DB_PRN.STI",	P_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFDRUNK,						"ANIMS\\F_MERC\\F_R_DRNK.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFPISTOLDRUNK,			"ANIMS\\F_MERC\\F_N_DRNK.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFCROWBAR,					"ANIMS\\F_MERC\\F_CROBAR.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFJUMPOVER,				"ANIMS\\F_MERC\\F_N_RUN.STI",		NO_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,


	AFMONSTERSTANDING,			"ANIMS\\MONSTERS\\MN_BREAT.STI",	S_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,
	AFMONSTERWALKING,				"ANIMS\\MONSTERS\\MN_WALK.STI",		S_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,
	AFMONSTERATTACK,				"ANIMS\\MONSTERS\\MN_ATTAK.STI",	S_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,
	AFMONSTERCLOSEATTACK,		"ANIMS\\MONSTERS\\M_ATTK2.STI",		S_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,
	AFMONSTERSPITATTACK,		"ANIMS\\MONSTERS\\M_SPIT.STI",		S_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,
	AFMONSTEREATING,				"ANIMS\\MONSTERS\\M_EAT.STI",			S_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,
	AFMONSTERDIE,						"ANIMS\\MONSTERS\\MN_DIE1.STI",		S_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,
	AFMUP,									"ANIMS\\MONSTERS\\MN_UP.STI",			S_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,
	AFMJUMP,								"ANIMS\\MONSTERS\\MN_JUMP.STI",		S_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,
	AFMMELT,								"ANIMS\\MONSTERS\\MN_MELT.STI",		S_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,


	LVBREATH,								"ANIMS\\MONSTERS\\L_BREATH.STI",	S_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,
	LVDIE,									"ANIMS\\MONSTERS\\L_DIE.STI",			S_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,
	LVWALK,									"ANIMS\\MONSTERS\\L_WALK.STI",		S_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,

	IBREATH,								"ANIMS\\MONSTERS\\I_BREATH.STI",	S_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,
	IWALK,									"ANIMS\\MONSTERS\\I_WALK.STI",		S_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,
	IDIE,										"ANIMS\\MONSTERS\\I_DIE.STI",			S_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,
	IEAT,										"ANIMS\\MONSTERS\\I_EAT.STI",			S_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,
	IATTACK,								"ANIMS\\MONSTERS\\I_ATTACK.STI",	S_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,

	QUEENMONSTERSTANDING,		"ANIMS\\MONSTERS\\QMN_BREAT.STI",		S_STRUCT,	0,				1, TO_INIT, NULL, NULL, 0, -1,
	QUEENMONSTERREADY,			"ANIMS\\MONSTERS\\Q_READY.STI",			S_STRUCT,	0,				1, TO_INIT, NULL, NULL, 0, -1,
	QUEENMONSTERSPIT_SW,		"ANIMS\\MONSTERS\\Q_SPIT_SW.STI",		S_STRUCT,	0,				1, TO_INIT, NULL, NULL, 0, -1,
	QUEENMONSTERSPIT_E,			"ANIMS\\MONSTERS\\Q_SPIT_E.STI",		S_STRUCT,	0,				1, TO_INIT, NULL, NULL, 0, -1,
	QUEENMONSTERSPIT_NE,		"ANIMS\\MONSTERS\\Q_SPIT_NE.STI",		S_STRUCT,	0,				1, TO_INIT, NULL, NULL, 0, -1,
	QUEENMONSTERSPIT_S,			"ANIMS\\MONSTERS\\Q_SPIT_S.STI",		S_STRUCT,	0,				1, TO_INIT, NULL, NULL, 0, -1,
	QUEENMONSTERSPIT_SE,		"ANIMS\\MONSTERS\\Q_SPIT_SE.STI",		S_STRUCT,	0,				1, TO_INIT, NULL, NULL, 0, -1,
	QUEENMONSTERDEATH,			"ANIMS\\MONSTERS\\Q_DIE.STI",				S_STRUCT,	0,				1, TO_INIT, NULL, NULL, 0, -1,
	QUEENMONSTERSWIPE,			"ANIMS\\MONSTERS\\Q_SWIPE.STI",			S_STRUCT,	0,				1, TO_INIT, NULL, NULL, 0, -1,

	FATMANSTANDING,			"ANIMS\\CIVS\\FT_BRTH.STI",		S_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	FATMANWALKING,			"ANIMS\\CIVS\\FT_WALK.STI",		S_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	FATMANRUNNING,			"ANIMS\\CIVS\\FT_RUN.STI",		S_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	FATMANDIE,					"ANIMS\\CIVS\\FT_DIE.STI",		F_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	FATMANASS,					"ANIMS\\CIVS\\FT_SCRTC.STI",	S_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	FATMANACT,					"ANIMS\\CIVS\\FT_ACT.STI",		S_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	FATMANCOWER,				"ANIMS\\CIVS\\FT_COWER.STI",	C_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	FATMANDIE2,					"ANIMS\\CIVS\\FT_DIE2.STI",		F_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	FATMANCOWERHIT,			"ANIMS\\CIVS\\F_CW_HIT.STI",	C_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,

	MANCIVSTANDING,			"ANIMS\\CIVS\\M_BREATH.STI",	S_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	MANCIVWALKING,			"ANIMS\\CIVS\\M_WALK.STI",		S_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	MANCIVRUNNING,			"ANIMS\\CIVS\\M_RUN.STI",			S_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	MANCIVDIE,					"ANIMS\\CIVS\\M_DIE.STI",			F_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	MANCIVACT,					"ANIMS\\CIVS\\M_ACT.STI",			S_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	MANCIVCOWER,				"ANIMS\\CIVS\\M_COWER.STI",		C_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	MANCIVDIE2,					"ANIMS\\CIVS\\M_DIE2.STI",		F_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	MANCIVSMACKED,			"ANIMS\\CIVS\\M_SMCKED.STI",	S_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	MANCIVPUNCH,				"ANIMS\\CIVS\\M_PUNCH.STI",		S_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	MANCIVCOWERHIT,			"ANIMS\\CIVS\\M_CW_HIT.STI",	C_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,

	MINICIVSTANDING,		"ANIMS\\CIVS\\MI_BREATH.STI",	S_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	MINICIVWALKING,			"ANIMS\\CIVS\\MI_WALK.STI",		S_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	MINICIVRUNNING,			"ANIMS\\CIVS\\MI_RUN.STI",		S_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	MINICIVDIE,					"ANIMS\\CIVS\\MI_DIE.STI",		F_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	MINISTOCKING,				"ANIMS\\CIVS\\MI_STKNG.STI",	S_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	MINIACT,						"ANIMS\\CIVS\\MI_ACT.STI",		S_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	MINICOWER,					"ANIMS\\CIVS\\MI_COWER.STI",	C_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	MINIDIE2,						"ANIMS\\CIVS\\MI_DIE2.STI",		F_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	MINICOWERHIT,				"ANIMS\\CIVS\\S_CW_HIT.STI",	C_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,

	DRESSCIVSTANDING,		"ANIMS\\CIVS\\DS_BREATH.STI",	S_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	DRESSCIVWALKING,		"ANIMS\\CIVS\\DS_WALK.STI",		S_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	DRESSCIVRUNNING,		"ANIMS\\CIVS\\DS_RUN.STI",		S_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	DRESSCIVDIE,				"ANIMS\\CIVS\\DS_DIE.STI",		F_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	DRESSCIVACT,				"ANIMS\\CIVS\\DS_ACT.STI",		S_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	DRESSCIVCOWER,			"ANIMS\\CIVS\\DS_COWER.STI",	C_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	DRESSCIVDIE2,				"ANIMS\\CIVS\\DS_DIE2.STI",		F_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	DRESSCIVCOWERHIT,		"ANIMS\\CIVS\\W_CW_HIT.STI",	C_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,

	HATKIDCIVSTANDING,	"ANIMS\\CIVS\\H_BREATH.STI",	S_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	HATKIDCIVWALKING,		"ANIMS\\CIVS\\H_WALK.STI",		S_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	HATKIDCIVRUNNING,		"ANIMS\\CIVS\\H_RUN.STI",			S_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	HATKIDCIVDIE,				"ANIMS\\CIVS\\H_DIE2.STI",		F_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	HATKIDCIVJFK,				"ANIMS\\CIVS\\H_DIEJFK.STI",	S_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	HATKIDCIVYOYO,			"ANIMS\\CIVS\\H_YOYO.STI",		S_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	HATKIDCIVACT,				"ANIMS\\CIVS\\H_ACT.STI",			S_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
 	HATKIDCIVCOWER,			"ANIMS\\CIVS\\H_COWER.STI",		S_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	HATKIDCIVDIE2,			"ANIMS\\CIVS\\H_DIE.STI",			F_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	HATKIDCIVCOWERHIT,	"ANIMS\\CIVS\\H_CW_HIT.STI",	C_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	HATKIDCIVSKIP,			"ANIMS\\CIVS\\H_SKIP.STI",		C_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,

	KIDCIVSTANDING,			"ANIMS\\CIVS\\K_BREATH.STI",	S_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	KIDCIVWALKING,			"ANIMS\\CIVS\\K_WALK.STI",		S_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	KIDCIVRUNNING,			"ANIMS\\CIVS\\K_RUN.STI",			S_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	KIDCIVDIE,					"ANIMS\\CIVS\\K_DIE2.STI",		F_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	KIDCIVJFK,					"ANIMS\\CIVS\\K_DIEJFK.STI",	S_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	KIDCIVARMPIT,				"ANIMS\\CIVS\\K_ARMPIT.STI",	S_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	KIDCIVACT,					"ANIMS\\CIVS\\K_ACT.STI",			S_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	KIDCIVCOWER,				"ANIMS\\CIVS\\K_COWER.STI",		S_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	KIDCIVDIE2,					"ANIMS\\CIVS\\K_DIE.STI",			F_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	KIDCIVCOWERHIT,			"ANIMS\\CIVS\\K_CW_HIT.STI",	C_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	KIDCIVSKIP,					"ANIMS\\CIVS\\K_SKIP.STI",		C_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,

	CRIPCIVSTANDING,		"ANIMS\\CIVS\\CP_BRETH.STI",	S_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	CRIPCIVWALKING,			"ANIMS\\CIVS\\CP_WALK.STI",		S_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	CRIPCIVRUNNING,			"ANIMS\\CIVS\\CP_RUN.STI",		S_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	CRIPCIVBEG,					"ANIMS\\CIVS\\CP_BEG.STI",		S_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	CRIPCIVDIE,					"ANIMS\\CIVS\\CP_DIE.STI",		S_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	CRIPCIVDIE2,				"ANIMS\\CIVS\\CP_DIE2.STI",		S_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,
	CRIPCIVKICK,				"ANIMS\\CIVS\\CP_KICK.STI",		S_STRUCT,	0,				8, TO_INIT, NULL, NULL, 0, -1,

	COWSTANDING,				"ANIMS\\ANIMALS\\C_BREATH.STI",	S_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,
	COWWALKING,					"ANIMS\\ANIMALS\\C_WALK.STI",		S_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,
	COWDIE,							"ANIMS\\ANIMALS\\C_DIE.STI",		S_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,
	COWEAT,							"ANIMS\\ANIMALS\\C_EAT.STI",		S_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,

	CROWWALKING,				"ANIMS\\ANIMALS\\CR_WALK.STI",	S_STRUCT,		0,		8, TO_INIT, NULL, NULL, 0, -1,
	CROWFLYING,					"ANIMS\\ANIMALS\\CR_FLY.STI",		S_STRUCT,		0,		8, TO_INIT, NULL, NULL, 0, -1,
	CROWEATING,					"ANIMS\\ANIMALS\\CR_EAT.STI",		S_STRUCT,		0,		8, TO_INIT, NULL, NULL, 0, -1,
	CROWDYING,					"ANIMS\\ANIMALS\\CR_DIE.STI",		NO_STRUCT,	0,		8, TO_INIT, NULL, NULL, 0, -1,

	CATBREATH,					"ANIMS\\ANIMALS\\CT_BREATH.STI",	S_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,
	CATWALK,						"ANIMS\\ANIMALS\\CT_WALK.STI",		S_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,
	CATRUN,							"ANIMS\\ANIMALS\\CT_RUN.STI",			S_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,
	CATREADY,						"ANIMS\\ANIMALS\\CT_READY.STI",		S_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,
	CATHIT,							"ANIMS\\ANIMALS\\CT_HIT.STI",			S_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,
	CATDIE,							"ANIMS\\ANIMALS\\CT_DIE.STI",			S_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,
	CATSWIPE,						"ANIMS\\ANIMALS\\CT_SWIPE.STI",		S_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,
	CATBITE,						"ANIMS\\ANIMALS\\CT_BITE.STI",		S_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,

	ROBOTNWBREATH,			"ANIMS\\CIVS\\J_R_BRET.STI",			S_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,
	ROBOTNWWALK,				"ANIMS\\CIVS\\J_R_WALK.STI",			S_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,
	ROBOTNWHIT,					"ANIMS\\CIVS\\J_R_HIT.STI"	,			S_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,
	ROBOTNWDIE,					"ANIMS\\CIVS\\J_R_DIE.STI",				S_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,
	ROBOTNWSHOOT,				"ANIMS\\CIVS\\J_R_SHOT.STI",			S_STRUCT,	0,			8, TO_INIT, NULL, NULL, 0, -1,

	HUMVEE_BASIC,				"ANIMS\\VEHICLES\\HUMMER2.STI",		S_STRUCT,	ANIM_DATA_FLAG_NOFRAMES,	32, TO_INIT, NULL, NULL, 0, -1,
	HUMVEE_DIE,					"ANIMS\\VEHICLES\\HM_WREK.STI",		S_STRUCT,	0,			2, TO_INIT, NULL, NULL, 0, -1,

	TANKNW_READY,				"ANIMS\\VEHICLES\\TANK_ROT.STI",	S_STRUCT,	ANIM_DATA_FLAG_NOFRAMES,	32, TO_INIT, NULL, NULL, 0, -1,
	TANKNW_SHOOT,				"ANIMS\\VEHICLES\\TANK_SHT.STI",	S_STRUCT,	0,												8,	TO_INIT, NULL, NULL, 0, -1,
	TANKNW_DIE,					"ANIMS\\VEHICLES\\TK_WREK.STI",		S_STRUCT,	0,												1,	TO_INIT, NULL, NULL, 0, -1,

	TANKNE_READY,				"ANIMS\\VEHICLES\\TNK2_ROT.STI",	S_STRUCT,	ANIM_DATA_FLAG_NOFRAMES,	32, TO_INIT, NULL, NULL, 0, -1,
	TANKNE_SHOOT,				"ANIMS\\VEHICLES\\TNK2_SHT.STI",	S_STRUCT,	0,												8,	TO_INIT, NULL, NULL, 0, -1,
	TANKNE_DIE,					"ANIMS\\VEHICLES\\TK2_WREK.STI",	S_STRUCT,	0,												1,	TO_INIT, NULL, NULL, 0, -1,
	//Kaiden: Below, I have replaced HUMMER2.STI with
	// ELDORADO.STI and JEEP.STI respectively,
	// This has not been tested for effect, however,
	// It should not result in anything worse than
	// Bad animations if it's not going to work.
	// And in that case, anyone comfortable with STI
	// Animations should be able to make them presentable.
	// Test it and remove it if neccessary.
	ELDORADO_BASIC,			"ANIMS\\VEHICLES\\ELDRDO.STI",		S_STRUCT,	ANIM_DATA_FLAG_NOFRAMES,	32, TO_INIT, NULL, NULL, 0, -1,
	ELDORADO_DIE,				"ANIMS\\VEHICLES\\HM_WREK.STI",		NO_STRUCT,	0,			2, TO_INIT, NULL, NULL, 0, -1,

	ICECREAMTRUCK_BASIC,"ANIMS\\VEHICLES\\ICECRM.STI",		S_STRUCT,	ANIM_DATA_FLAG_NOFRAMES,	32, TO_INIT, NULL, NULL, 0, -1,
	ICECREAMTRUCK_DIE,	"ANIMS\\VEHICLES\\HM_WREK.STI",		NO_STRUCT,	0,			2, TO_INIT, NULL, NULL, 0, -1,

	JEEP_BASIC,					"ANIMS\\VEHICLES\\JEEP.STI",		S_STRUCT,	ANIM_DATA_FLAG_NOFRAMES,	32, TO_INIT, NULL, NULL, 0, -1,
	JEEP_DIE,						"ANIMS\\VEHICLES\\HM_WREK.STI",		NO_STRUCT,	0,			2, TO_INIT, NULL, NULL, 0, -1,

	BODYEXPLODE,				"ANIMS\\S_MERC\\BOD_BLOW.STI",		NO_STRUCT,	0,				1, TO_INIT, NULL, NULL, 0, -1,

	//<SB> crouch throwing
	RGMCRTHROW,	"ANIMS\\S_MERC\\S_CR_THR.STI",	C_STRUCT,	0,	8, TO_INIT,	NULL,	NULL,	0,	-1,
	BGMCRTHROW,	"ANIMS\\M_MERC\\M_CR_THR.STI",	C_STRUCT,	0,	8, TO_INIT,	NULL,	NULL,	0,	-1,
	RGFCRTHROW,	"ANIMS\\F_MERC\\F_CR_THR.STI",	C_STRUCT,	0,	8, TO_INIT,	NULL,	NULL,	0,	-1,
	//</SB>
	//ddd big man with stone
	BGMWITHSTONE,	"ANIMS\\M_MERC\\M_STEIN.STI",	C_STRUCT,	0,	8, TO_INIT,	NULL,	NULL,	0,	-1,
	//ddd crouched shoot rocket
	RGMCRROCKET, "ANIMS\\S_MERC\\S_LAW_CR.sti",	C_STRUCT,	0,	8, TO_INIT,	NULL,	NULL,	0,	-1,
	BGMCRROCKET, "ANIMS\\M_MERC\\M_LAW_CR.sti",	C_STRUCT,	0,	8, TO_INIT,	NULL,	NULL,	0,	-1,
	RGFCRROCKET, "ANIMS\\F_MERC\\F_LAW_CR.sti",	C_STRUCT,	0,	8, TO_INIT,	NULL,	NULL,	0,	-1,

	BGMSWKNIFE , "ANIMS\\M_MERC\\M_K_SWAT_K.sti",	C_STRUCT,	0,	8, TO_INIT,	NULL,	NULL,	0,	-1,
	RGFSWKNIFE , "ANIMS\\F_MERC\\F_K_SWAT_K.sti",	C_STRUCT,	0,	8, TO_INIT,	NULL,	NULL,	0,	-1,
	RGMSWKNIFE , "ANIMS\\S_MERC\\S_K_SWAT.sti",	C_STRUCT,	0,	8, TO_INIT,	NULL,	NULL,	0,	-1,

	//      2 
	BGMSTHRG,						"ANIMS\\M_MERC\\M_THROW_G.sti",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	//    
	RGFSTHRG,						"ANIMS\\F_MERC\\F_THROW.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMSTHRG,						"ANIMS\\S_MERC\\S_THROW_G.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	
	BGMSLOBG,						"ANIMS\\M_MERC\\M_THROW_GLOB.sti",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFSLOBG,						"ANIMS\\F_MERC\\F_LOB.STI",			S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGMSLOBG,						"ANIMS\\S_MERC\\S_THROW_GLOB.sti",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	//
	RGMROLL_PR,				"ANIMS\\S_MERC\\S_ROLL_N.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMROLL_PR,				"ANIMS\\M_MERC\\M_ROLL_N.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFROLL_PR,				"ANIMS\\F_MERC\\F_ROLL_N.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	
	RGMWALLJUMP,				"ANIMS\\S_MERC\\S_CLIMB.STI",		S_STRUCT,		0,			4, TO_INIT, NULL, NULL, 0, -1,
	BGMWALLJUMP,				"ANIMS\\M_MERC\\M_CLIMB.STI",		S_STRUCT,		0,			4, TO_INIT, NULL, NULL, 0, -1,
	RGFWALLJUMP,				"ANIMS\\F_MERC\\F_CLIMB.STI",		S_STRUCT,		0,			4, TO_INIT, NULL, NULL, 0, -1,
	
	RGMJUMPWINDOWS,				"ANIMS\\S_MERC\\S_HOP.STI",			NO_STRUCT,	0,			4, TO_INIT, NULL, NULL, 0, -1,
	BGMJUMPWINDOWS,				"ANIMS\\M_MERC\\M_HOP.STI",			NO_STRUCT,	0,			4, TO_INIT, NULL, NULL, 0, -1,
	RGFJUMPWINDOWS,				"ANIMS\\F_MERC\\F_HOP.STI",			NO_STRUCT,	0,			4, TO_INIT, NULL, NULL, 0, -1,
	
	// SANDRO - new animation of remote detonator by PasHancock
	RGMUSEREMOTE,						"ANIMS\\S_MERC\\S_USEREMOTE.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMUSEREMOTE,						"ANIMS\\M_MERC\\M_USEREMOTE.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFUSEREMOTE,						"ANIMS\\F_MERC\\F_USEREMOTE.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	
	BGMTHROWKNIFE,			"ANIMS\\M_MERC\\M_K_THRO2.STI",	S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,

	RGMPISTOL_RUN,			"ANIMS\\S_MERC\\S_P_RUN.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	BGMPISTOL_RUN,			"ANIMS\\M_MERC\\M_P_RUN.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,
	RGFPISTOL_RUN,			"ANIMS\\F_MERC\\F_P_RUN.STI",		S_STRUCT,		0,			8, TO_INIT, NULL, NULL, 0, -1,

};


AnimationStructureType	gAnimStructureDatabase[ TOTALBODYTYPES ][ NUM_STRUCT_IDS ] =
{
	// Normal Male
	"ANIMS\\STRUCTDATA\\M_STAND.JSD",			NULL,
	"ANIMS\\STRUCTDATA\\M_CROUCH.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\M_PRONE.JSD",			NULL,
	"ANIMS\\STRUCTDATA\\M_FALL.JSD",			NULL,
	"ANIMS\\STRUCTDATA\\M_FALLBACK.JSD",	NULL,
	"ANIMS\\STRUCTDATA\\M_CROUCH.JSD",		NULL,// default

	// Big male
	"ANIMS\\STRUCTDATA\\M_STAND.JSD",			NULL,
	"ANIMS\\STRUCTDATA\\M_CROUCH.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\M_PRONE.JSD",			NULL,
	"ANIMS\\STRUCTDATA\\M_FALL.JSD",			NULL,
	"ANIMS\\STRUCTDATA\\M_FALLBACK.JSD",	NULL,
	"ANIMS\\STRUCTDATA\\M_CROUCH.JSD",		NULL,// default

	// Stocky male
	"ANIMS\\STRUCTDATA\\M_STAND.JSD",			NULL,
	"ANIMS\\STRUCTDATA\\M_CROUCH.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\M_PRONE.JSD",			NULL,
	"ANIMS\\STRUCTDATA\\M_FALL.JSD",			NULL,
	"ANIMS\\STRUCTDATA\\M_FALLBACK.JSD",	NULL,
	"ANIMS\\STRUCTDATA\\M_CROUCH.JSD",		NULL,// default

	// Reg Female
	"ANIMS\\STRUCTDATA\\M_STAND.JSD",			NULL,
	"ANIMS\\STRUCTDATA\\M_CROUCH.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\M_PRONE.JSD",			NULL,
	"ANIMS\\STRUCTDATA\\M_FALL.JSD",			NULL,
	"ANIMS\\STRUCTDATA\\M_FALLBACK.JSD",	NULL,
	"ANIMS\\STRUCTDATA\\M_CROUCH.JSD",		NULL,// default

	// Adult female creature
	"ANIMS\\STRUCTDATA\\MN_BREAT.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\MN_BREAT.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\MN_BREAT.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\MN_BREAT.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\MN_BREAT.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\M_CROUCH.JSD",		NULL,// default

	// Adult male creature
	"ANIMS\\STRUCTDATA\\MN_BREAT.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\MN_BREAT.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\MN_BREAT.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\MN_BREAT.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\MN_BREAT.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\M_CROUCH.JSD",		NULL,// default

	// Young Adult female creature
	"ANIMS\\STRUCTDATA\\MN_BREAT.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\MN_BREAT.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\MN_BREAT.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\MN_BREAT.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\MN_BREAT.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\M_CROUCH.JSD",		NULL,// default

	// Young Adult male creature
	"ANIMS\\STRUCTDATA\\MN_BREAT.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\MN_BREAT.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\MN_BREAT.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\MN_BREAT.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\MN_BREAT.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\M_CROUCH.JSD",		NULL,// default

	// larvea creature
	"ANIMS\\STRUCTDATA\\L_BREATH.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\L_BREATH.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\L_BREATH.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\L_BREATH.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\L_BREATH.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\M_CROUCH.JSD",		NULL,// default

	// infant creature
	"ANIMS\\STRUCTDATA\\I_BREATH.JSD",			NULL,
	"ANIMS\\STRUCTDATA\\I_BREATH.JSD",			NULL,
	"ANIMS\\STRUCTDATA\\I_BREATH.JSD",			NULL,
	"ANIMS\\STRUCTDATA\\I_BREATH.JSD",			NULL,
	"ANIMS\\STRUCTDATA\\I_BREATH.JSD",			NULL,
	"ANIMS\\STRUCTDATA\\I_BREATH.JSD",			NULL,// default

	// Queen creature
	"ANIMS\\STRUCTDATA\\Q_READY.JSD",			NULL,
	"ANIMS\\STRUCTDATA\\Q_READY.JSD",			NULL,
	"ANIMS\\STRUCTDATA\\Q_READY.JSD",			NULL,
	"ANIMS\\STRUCTDATA\\Q_READY.JSD",			NULL,
	"ANIMS\\STRUCTDATA\\Q_READY.JSD",			NULL,
	"ANIMS\\STRUCTDATA\\M_CROUCH.JSD",		NULL,// default

	// Fat civ
	"ANIMS\\STRUCTDATA\\M_STAND.JSD",			NULL,
	"ANIMS\\STRUCTDATA\\M_CROUCH.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\M_PRONE.JSD",			NULL,
	"ANIMS\\STRUCTDATA\\M_FALL.JSD",			NULL,
	"ANIMS\\STRUCTDATA\\M_FALLBACK.JSD",	NULL,
	"ANIMS\\STRUCTDATA\\M_CROUCH.JSD",		NULL, // default

	// man civ
	"ANIMS\\STRUCTDATA\\M_STAND.JSD",			NULL,
	"ANIMS\\STRUCTDATA\\M_CROUCH.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\M_PRONE.JSD",			NULL,
	"ANIMS\\STRUCTDATA\\M_FALL.JSD",			NULL,
	"ANIMS\\STRUCTDATA\\M_FALLBACK.JSD",	NULL,
	"ANIMS\\STRUCTDATA\\M_CROUCH.JSD",		NULL, // default

	// miniskirt civ
	"ANIMS\\STRUCTDATA\\M_STAND.JSD",			NULL,
	"ANIMS\\STRUCTDATA\\M_CROUCH.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\M_PRONE.JSD",			NULL,
	"ANIMS\\STRUCTDATA\\M_FALL.JSD",			NULL,
	"ANIMS\\STRUCTDATA\\M_FALLBACK.JSD",	NULL,
	"ANIMS\\STRUCTDATA\\M_CROUCH.JSD",		NULL, // default

	// dress civ
	"ANIMS\\STRUCTDATA\\M_STAND.JSD",			NULL,
	"ANIMS\\STRUCTDATA\\M_CROUCH.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\M_PRONE.JSD",			NULL,
	"ANIMS\\STRUCTDATA\\M_FALL.JSD",			NULL,
	"ANIMS\\STRUCTDATA\\M_FALLBACK.JSD",	NULL,
	"ANIMS\\STRUCTDATA\\M_CROUCH.JSD",		NULL, // default

	// kid civ
	"ANIMS\\STRUCTDATA\\K_STAND.JSD",			NULL,
	"ANIMS\\STRUCTDATA\\K_CROUCH.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\K_CROUCH.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\M_PRONE.JSD",			NULL,
	"ANIMS\\STRUCTDATA\\M_PRONE.JSD",			NULL,
	"ANIMS\\STRUCTDATA\\M_PRONE.JSD",			NULL,

	// hat kid civ
	"ANIMS\\STRUCTDATA\\K_STAND.JSD",			NULL,
	"ANIMS\\STRUCTDATA\\K_CROUCH.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\K_CROUCH.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\M_PRONE.JSD",			NULL,
	"ANIMS\\STRUCTDATA\\M_PRONE.JSD",			NULL,
	"ANIMS\\STRUCTDATA\\M_PRONE.JSD",			NULL,

	// cripple civ
	"ANIMS\\STRUCTDATA\\M_CROUCH.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\M_CROUCH.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\M_CROUCH.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\M_FALL.JSD",			NULL,
	"ANIMS\\STRUCTDATA\\M_FALLBACK.JSD",	NULL,
	"ANIMS\\STRUCTDATA\\M_CROUCH.JSD",		NULL, // default

	// cow
	"ANIMS\\STRUCTDATA\\CW_BREATH.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\CW_BREATH.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\CW_BREATH.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\CW_BREATH.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\CW_BREATH.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\M_CROUCH.JSD",		NULL, // default

	// crow
	"ANIMS\\STRUCTDATA\\CR_STAND.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\CR_CROUCH.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\CR_PRONE.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\CR_PRONE.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\CR_PRONE.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\M_CROUCH.JSD",		NULL, // default

	// CAT
	"ANIMS\\STRUCTDATA\\CT_BREATH.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\CT_BREATH.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\CT_BREATH.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\CT_BREATH.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\CT_BREATH.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\M_CROUCH.JSD",		NULL, // default

	// ROBOT1
	"ANIMS\\STRUCTDATA\\J_R_BRET.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\J_R_BRET.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\J_R_BRET.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\J_R_BRET.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\J_R_BRET.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\J_R_BRET.JSD",		NULL, // default

	// vech 1
	"ANIMS\\STRUCTDATA\\HMMV.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\HMMV.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\HMMV.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\HMMV.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\HMMV.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\M_CROUCH.JSD",NULL, // default

	// tank 1
	"ANIMS\\STRUCTDATA\\TNK_SHT.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\TNK_SHT.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\TNK_SHT.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\TNK_SHT.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\TNK_SHT.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\M_CROUCH.JSD",	NULL, // default

	// tank 2
	"ANIMS\\STRUCTDATA\\TNK2_ROT.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\TNK2_ROT.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\TNK2_ROT.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\TNK2_ROT.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\TNK2_ROT.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\M_CROUCH.JSD",		NULL, // default

	//ELDORADO
	"ANIMS\\STRUCTDATA\\HMMV.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\HMMV.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\HMMV.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\HMMV.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\HMMV.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\M_CROUCH.JSD",NULL, // default

	//ICECREAMTRUCK
	"ANIMS\\STRUCTDATA\\HMMV.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\HMMV.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\HMMV.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\HMMV.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\HMMV.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\M_CROUCH.JSD",NULL, // default

	//JEEP
	"ANIMS\\STRUCTDATA\\HMMV.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\HMMV.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\HMMV.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\HMMV.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\HMMV.JSD",		NULL,
	"ANIMS\\STRUCTDATA\\M_CROUCH.JSD",NULL, // default

};




BOOLEAN InitAnimationSystem( )
{
	INT32									cnt1, cnt2;
	CHAR8									sFilename[50];
	STRUCTURE_FILE_REF		*pStructureFileRef;

	CHECKF( LoadAnimationStateInstructions( ) );

	InitAnimationSurfacesPerBodytype( );

	if ( !LoadAnimationProfiles( ) )
	{
		return( SET_ERROR( "Problems initializing Animation Profiles" ) );
	}

	// OK, Load all animation structures.....
	for ( cnt1 = 0; cnt1 < TOTALBODYTYPES; cnt1++ )
	{
		for ( cnt2 = 0; cnt2 < NUM_STRUCT_IDS; cnt2++ )
		{
			strcpy( sFilename, gAnimStructureDatabase[ cnt1 ][ cnt2 ].Filename );

			if (FileExists( sFilename ) )
			{
				pStructureFileRef = LoadStructureFile( sFilename );
				if (pStructureFileRef == NULL)
				{
					SET_ERROR(	"Animation structure file load failed - %s", sFilename );
				}
				gAnimStructureDatabase[ cnt1 ][ cnt2 ].pStructureFileRef = pStructureFileRef;
			}
		}
	}

	return( TRUE );
}

BOOLEAN DeInitAnimationSystem( )
{
	INT32									cnt1, cnt2;

	for ( cnt1 = 0; cnt1 < NUMANIMATIONSURFACETYPES; cnt1++ )
	{
			if ( gAnimSurfaceDatabase[ cnt1 ].hVideoObject != NULL )
			{
					DeleteVideoObject( gAnimSurfaceDatabase[ cnt1 ].hVideoObject );
					gAnimSurfaceDatabase[ cnt1 ].hVideoObject = NULL;
			}
	}

		// OK, Delete all animation structures.....
	// ATE: OK, don't delete here.. we be deleted when the structure database is destoryed....
		for ( cnt1 = 0; cnt1 < TOTALBODYTYPES; cnt1++ )
		{
			for ( cnt2 = 0; cnt2 < 3; cnt2++ )
			{
				if ( gAnimStructureDatabase[ cnt1 ][ cnt2 ].pStructureFileRef != NULL )
				{
				//	FreeStructureFile( gAnimStructureDatabase[ cnt1 ][ cnt2 ].pStructureFileRef );
				//	gAnimStructureDatabase[ cnt1 ][ cnt2 ].pStructureFileRef = NULL;
				}
			}
		}

	DeleteAnimationProfiles( );

	return( TRUE );
}



STRUCTURE_FILE_REF	*InternalGetAnimationStructureRef( UINT8 usSoldierID, UINT16 usSurfaceIndex, UINT16 usAnimState, BOOLEAN fUseAbsolute )
{
	INT8	bStructDataType;

	if ( usSurfaceIndex == INVALID_ANIMATION_SURFACE )
	{
		return( NULL );
	}

	bStructDataType = gAnimSurfaceDatabase[ usSurfaceIndex ].bStructDataType;

	if ( bStructDataType == NO_STRUCT )
	{
		return( NULL );
	}

	// ATE: Alright - we all hate exception coding but ness here...
	// return STANDING struct for these - which start standing but end prone
	// CJC August 14 2002: added standing burst hit to this list
	if ( ( usAnimState == FALLFORWARD_FROMHIT_STAND || usAnimState == GENERIC_HIT_STAND ||
			usAnimState == FALLFORWARD_FROMHIT_CROUCH || usAnimState == STANDING_BURST_HIT ) && !fUseAbsolute )
	{
		return( gAnimStructureDatabase[ MercPtrs[ usSoldierID ]->ubBodyType ][ S_STRUCT ].pStructureFileRef );
	}

	return( gAnimStructureDatabase[ MercPtrs[ usSoldierID ]->ubBodyType ][ bStructDataType ].pStructureFileRef );
}


STRUCTURE_FILE_REF	*GetAnimationStructureRef( UINT8 usSoldierID, UINT16 usSurfaceIndex, UINT16 usAnimState )
{
	return( InternalGetAnimationStructureRef( usSoldierID, usSurfaceIndex, usAnimState, FALSE ) );
}


STRUCTURE_FILE_REF	*GetDefaultStructureRef( UINT8 usSoldierID )
{
	return( gAnimStructureDatabase[ MercPtrs[ usSoldierID ]->ubBodyType ][ DEFAULT_STRUCT ].pStructureFileRef );
}

// Surface mamagement functions
BOOLEAN LoadAnimationSurface( UINT16 usSoldierID, UINT16 usSurfaceIndex, UINT16 usAnimState )
{
	AuxObjectData *pAuxData;

	// Check for valid surface
	CHECKF( usSurfaceIndex < NUMANIMATIONSURFACETYPES );

	// Check if surface is loaded
	if ( gAnimSurfaceDatabase[ usSurfaceIndex ].hVideoObject != NULL )
	{
		// just increment usage counter ( below )
		AnimDebugMsg( String( "Surface Database: Hit %d", usSurfaceIndex ) );

	}
	else
	{
		// Load into memory
		VOBJECT_DESC					VObjectDesc;
		HVOBJECT							hVObject;
		HIMAGE								hImage;
		CHAR8									sFilename[48];
		STRUCTURE_FILE_REF		*pStructureFileRef;

		AnimDebugMsg( String( "Surface Database: Loading %d", usSurfaceIndex ) );

		sprintf( gSystemDebugStr, "Cache Load" );

	// Create video object
		FilenameForBPP(gAnimSurfaceDatabase[ usSurfaceIndex ].Filename, sFilename);
		hImage = CreateImage(/*gAnimSurfaceDatabase[ usSurfaceIndex ].Filename*/sFilename, IMAGE_ALLDATA );

	if (hImage == NULL)
	{
			return( SET_ERROR( "Error: Could not load animation file %s", sFilename ) );
	}

		VObjectDesc.fCreateFlags = VOBJECT_CREATE_FROMHIMAGE;
		VObjectDesc.hImage = hImage;

		hVObject = CreateVideoObject( &VObjectDesc );

		if ( hVObject == NULL )
		{
			// Report error
			SET_ERROR( "Could not load animation file: %s", gAnimSurfaceDatabase[ usSurfaceIndex ].Filename );
			// Video Object will set error conition.]
			DestroyImage( hImage );
			return( FALSE );
		}

		// Get aux data
		if (hImage->uiAppDataSize == hVObject->usNumberOfObjects * sizeof( AuxObjectData ))
		{
			// Valid auxiliary data, so get # od frames from data
			pAuxData = ( AuxObjectData* ) hImage->pAppData;

			gAnimSurfaceDatabase[ usSurfaceIndex ].uiNumFramesPerDir = pAuxData->ubNumberOfFrames;

		}
		else
		{
			// Report error
			SET_ERROR( "Invalid # of animations given" );
			DestroyImage( hImage );
			return( FALSE );
		}

		// get structure data if any
		pStructureFileRef = InternalGetAnimationStructureRef( (UINT8)usSoldierID, usSurfaceIndex, usAnimState, TRUE );

		if ( pStructureFileRef != NULL )
		{
			INT16 sStartFrame = 0;

			if ( usSurfaceIndex == RGMPRONE )
			{
				sStartFrame = 5;
			}
			else if ( usSurfaceIndex >= QUEENMONSTERSTANDING && usSurfaceIndex <= QUEENMONSTERSWIPE )
			{
				sStartFrame = -1;
			}

			if (AddZStripInfoToVObject( hVObject, pStructureFileRef, TRUE, sStartFrame ) == FALSE)
			{
				DestroyImage( hImage );
				DeleteVideoObject( hVObject );
				SET_ERROR(	"Animation structure ZStrip creation error: %s", sFilename );
				return( FALSE );
			}

		}

	// the hImage is no longer needed
	DestroyImage( hImage );

		// Set video object index
		gAnimSurfaceDatabase[ usSurfaceIndex ].hVideoObject = hVObject;

		// Determine if we have a problem with #frames + directions ( ie mismatch )
		if (	( gAnimSurfaceDatabase[ usSurfaceIndex ].uiNumDirections * gAnimSurfaceDatabase[ usSurfaceIndex ].uiNumFramesPerDir ) != gAnimSurfaceDatabase[ usSurfaceIndex ].hVideoObject->usNumberOfObjects )
		{
			AnimDebugMsg( String( "Surface Database: WARNING!!! Surface %d has #frames mismatch.", usSurfaceIndex ) );
		}
	}

	// Increment usage count only if history for soldier is not yet set
	if ( gbAnimUsageHistory[ usSurfaceIndex ][ usSoldierID ] == 0 )
	{
		AnimDebugMsg( String( "Surface Database: Incrementing Usage %d ( Soldier %d )", usSurfaceIndex, usSoldierID ) );
		// Increment usage count
		gAnimSurfaceDatabase[ usSurfaceIndex ].bUsageCount++;
		// Set history for particular sodlier
		gbAnimUsageHistory[ usSurfaceIndex ][ usSoldierID ]++;

	}

	return( TRUE );
}


BOOLEAN UnLoadAnimationSurface( UINT16 usSoldierID, UINT16 usSurfaceIndex )
{
	// Decrement usage flag, only if this soldier has it currently tagged
	if ( gbAnimUsageHistory[ usSurfaceIndex ][ usSoldierID ] > 0 )
	{
		// Decrement usage count
		AnimDebugMsg( String( "Surface Database: Decrementing Usage %d ( Soldier %d )", usSurfaceIndex, usSoldierID ) );
		gAnimSurfaceDatabase[ usSurfaceIndex ].bUsageCount--;
		// Set history for particular sodlier
		gbAnimUsageHistory[ usSurfaceIndex ][ usSoldierID ] = 0;

	}
	else
	{
		// Return warning that we have not actually loaded the surface previously
		AnimDebugMsg( String( "Surface Database: WARNING!!! Soldier has tried to unlock surface that he has not locked." ) );
		return( FALSE );
	}

	AnimDebugMsg( String( "Surface Database: MercUsage: %d, Global Uasage: %d", gbAnimUsageHistory[ usSurfaceIndex ][ usSoldierID ], gAnimSurfaceDatabase[ usSurfaceIndex ].bUsageCount ) );

	// Check for < 0
	if ( gAnimSurfaceDatabase[ usSurfaceIndex ].bUsageCount < 0 )
	{
		gAnimSurfaceDatabase[ usSurfaceIndex ].bUsageCount = 0;
	}




	// Check if count has reached zero and delet if so
	if ( gAnimSurfaceDatabase[ usSurfaceIndex ].bUsageCount == 0 )
	{
		AnimDebugMsg( String( "Surface Database: Unloading Surface: %d", usSurfaceIndex ) );

		CHECKF( gAnimSurfaceDatabase[ usSurfaceIndex ].hVideoObject != NULL )

			DeleteVideoObject( gAnimSurfaceDatabase[ usSurfaceIndex ].hVideoObject );
			gAnimSurfaceDatabase[ usSurfaceIndex ].hVideoObject = NULL;
	}

	return( TRUE );

}

void ClearAnimationSurfacesUsageHistory( UINT16 usSoldierID )
{
	UINT32 cnt;

	for( cnt = 0; cnt < NUMANIMATIONSURFACETYPES; cnt++ )
	{
		gbAnimUsageHistory[ cnt ][ usSoldierID ] = 0;
	}
}


BOOLEAN LoadAnimationProfiles( )
{
//	FILE *			pInput;
	HWFILE			pInput;
	INT32				iProfileCount, iDirectionCount, iTileCount;
	ANIM_PROF					*pProfile;
	ANIM_PROF_DIR			*pProfileDirs;
	UINT32			uiBytesRead;

//	pInput = fopen( ANIMPROFILEFILENAME, "rb" );
	pInput = FileOpen( ANIMPROFILEFILENAME, FILE_ACCESS_READ, FALSE );

	if ( !pInput )
	{
		return( FALSE );
	}

	// Writeout profile data!
//	if ( fread( &gubNumAnimProfiles, sizeof( gubNumAnimProfiles ), 1, pInput ) != 1 )
	if ( FileRead(	pInput, &gubNumAnimProfiles, sizeof( gubNumAnimProfiles ), &uiBytesRead ) != 1 )
	{
		return( FALSE );
	}

	// Malloc profile data!
	gpAnimProfiles = (ANIM_PROF *) MemAlloc( gubNumAnimProfiles * sizeof( ANIM_PROF ) );

	// Loop profiles
	for ( iProfileCount = 0; iProfileCount < gubNumAnimProfiles; iProfileCount++ )
	{
		// Get profile pointer
		pProfile = &( gpAnimProfiles[ iProfileCount ] );

		// Loop directions
		for ( iDirectionCount = 0; iDirectionCount < 8; iDirectionCount++ )
		{
			// Get prodile direction pointer
			pProfileDirs = &( gpAnimProfiles[ iProfileCount ].Dirs[ iDirectionCount ] );

			// Read # tiles
//			if ( fread( &pProfileDirs->ubNumTiles, sizeof( UINT8 ), 1, pInput ) != 1 )
			if ( FileRead( pInput, &pProfileDirs->ubNumTiles, sizeof( UINT8 ), &uiBytesRead ) != 1 )
			{
				return( FALSE );
			}

			// Malloc space for tiles!
			pProfileDirs->pTiles = (ANIM_PROF_TILE *) MemAlloc( sizeof( ANIM_PROF_TILE ) * pProfileDirs->ubNumTiles );

			// Loop tiles
			for ( iTileCount = 0; iTileCount < pProfileDirs->ubNumTiles; iTileCount++ )
			{
//				if ( fread( &pProfileDirs->pTiles[ iTileCount ].usTileFlags, sizeof( UINT16 ), 1, pInput ) != 1 )
				if ( FileRead( pInput, &pProfileDirs->pTiles[ iTileCount ].usTileFlags, sizeof( UINT16 ), &uiBytesRead ) != 1 )
				{
					return( FALSE );
				}

//				if ( fread( &pProfileDirs->pTiles[ iTileCount ].bTileX, sizeof( INT8 ), 1, pInput ) != 1 )
				if ( FileRead( pInput, &pProfileDirs->pTiles[ iTileCount ].bTileX, sizeof( INT8 ), &uiBytesRead ) != 1 )
				{
					return( FALSE );
				}

//				if ( fread( &pProfileDirs->pTiles[ iTileCount ].bTileY, sizeof( INT8 ), 1, pInput ) != 1 )
				if ( FileRead( pInput, &pProfileDirs->pTiles[ iTileCount ].bTileY, sizeof( INT8 ), &uiBytesRead ) != 1 )
				{
					return( FALSE );
				}

			}

		}
	}

//	fclose( pInput );
	FileClose( pInput );

	return( TRUE );
}


void DeleteAnimationProfiles( )
{
	INT32				iProfileCount, iDirectionCount;
	ANIM_PROF					*pProfile;
	ANIM_PROF_DIR			*pProfileDir;

	// Loop profiles
	for ( iProfileCount = 0; iProfileCount < gubNumAnimProfiles; iProfileCount++ )
	{
		// Get profile pointer
		pProfile = &( gpAnimProfiles[ iProfileCount ] );

		// Loop directions
		for ( iDirectionCount = 0; iDirectionCount < 8; iDirectionCount++ )
		{
			// Get prodile direction pointer
			pProfileDir = &( gpAnimProfiles[ iProfileCount ].Dirs[ iDirectionCount ] );

			// Free tile
			MemFree( pProfileDir->pTiles );

		}
	}

	// Free profile data!
	MemFree( gpAnimProfiles );

}


void ZeroAnimSurfaceCounts( )
{
	INT32 cnt;

	for ( cnt = 0; cnt < NUMANIMATIONSURFACETYPES; cnt++ )
	{
	gAnimSurfaceDatabase[ cnt ].bUsageCount	= 0;
	gAnimSurfaceDatabase[ cnt ].hVideoObject	= NULL;
	}

	memset( gbAnimUsageHistory, 0, sizeof( gbAnimUsageHistory ) );
}
